definition module StdIOBasic


//	********************************************************************************
//	Clean Standard Object I/O library, version 1.1
//	
//	StdIOBasic defines basic types and access functions for the I/O library.
//	********************************************************************************


import	StdOverloaded, StdString


/*	General type constructors for composing context-independent data structures.
*/
::	:^:		t1 t2			= (:^:) infixr 9 t1 t2


/*	General type constructors for composing context-dependent data structures.
*/
::	:~:		t1 t2		cs	= (:~:) infixr 9 (t1 cs) (t2 cs)
::	ListCS		t		cs	= ListCS [t cs]
::	NilCS				cs	= NilCS


/*	General type constructors for composing local and context-dependent 
	data structures.
*/
::	:+:		t1 t2	ls	cs	= (:+:) infixr 9 (t1 ls cs) (t2 ls cs)
::	ListLS		t	ls	cs	= ListLS [t ls cs]
::	NilLS			ls	cs	= NilLS
::	NewLS		t	ls	cs	= E..new: {newLS::new, newDef:: t   new		cs}
::	AddLS		t	ls	cs	= E..add: {addLS::add, addDef:: t *(add,ls)	cs}

noLS ::     (.a->.b)    (.c,.a) -> (.c,.b)	// Lift function    a  ->  b
											// to             (c,a)->(c,b)
noLS1:: (.x->.a->.b) .x (.c,.a) -> (.c,.b)	// Lift function x->  a  ->  b
											// to            x->(c,a)->(c,b)

::	Void			=	Void
::	Index			:==	Int
::	Title			:==	String


::	Vector			=	{vx::!Int,vy::!Int}

instance			==			Vector		// @1-@2==zero
instance			+			Vector		// {vx=@1.vx+@2.vx,vy=@1.vy+@2.vy}
instance			-			Vector		// {vx=@1.vx-@2.vx,vy=@1.vy-@2.vy}
instance			zero		Vector		// {vx=0,vy=0}
instance			~			Vector		// zero-@1
instance			toString	Vector

class toVector		x :: !x ->	Vector


::	Size			=	{w ::!Int,h ::!Int}

instance			==			Size		// @1.w==@2.w && @1.h==@2.h
instance			zero		Size		// {w=0,h=0}
instance			toVector	Size		// {w,h}->{vx=w,vy=h}
instance			toString	Size


::	Point	
	=	{	x		:: !Int
		,	y		:: !Int
		}
::	Rectangle
	=	{	corner1	:: !Point
		,	corner2	:: !Point
		}

instance			==			Point		// @1-@2==zero
instance			+			Point		// {x=@1.x+@2.x,y=@1.y+@2.y}
instance			-			Point 		// {x=@1.x-@2.x,y=@1.y-@2.y}
instance			zero		Point		// {x=0,y=0}
instance			toVector	Point		// {x,y}->{vx=x,vy=y}
instance			toString	Point

instance			==			Rectangle	//    @1.corner1==@2.corner1
											// && @1.corner2==@2.corner2
instance			zero		Rectangle	// {corner1=zero,corner2=zero}
instance			toString	Rectangle

rectangleSize		:: !Rectangle -> Size	// {w=abs (@1.corner1-@1.corner2).x,
											//  h=abs (@1.corner1-@1.corner2).y}
movePoint	:: !Vector !Point -> Point		// {vx,vy} {x,y} -> {vx+x,vy+y}


::	IdFun ps		:==	ps -> ps
